// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function GetArrayDirPoint( pointpicker )
{
	var ui = moi.ui;

	while ( 1 )
	{
		ui.beginUIUpdate();
		ui.hideUI( 'NumItemsTable' );

		if ( ui.commandUI.Mode.value == 'Offset, Extent' )
			ui.hideUI( 'NumItemsTable' );
		else
			ui.showUI( 'NumItemsTable' );

		ui.endUIUpdate();
				
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'finished' )
			break;
	}
	
	return true;
}

function DoArrayDir()
{
	// First get the objects to array.

	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	var factory = moi.command.createFactory( 'arraydir' );
	factory.setInput( 0, objects );

	// Show the number of items control and bind it to the factory.
	ui.beginUIUpdate();
	ui.hideUI( 'SelectPrompt' );
	ui.hideUI( 'done' );
	ui.showUI( 'BasePtPrompt' );
	ui.showUI( 'ArrayOptions' );
	ui.endUIUpdate();

	ui.bindUIToInput( 'Mode', 'value', factory.getInput(5) );
	ui.bindUIToInput( 'NumItems', 'value', factory.getInput(1) );
	
	// Pick the base point.

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.bindResultPt( factory.getInput(2) );
	
	if ( !GetArrayDirPoint( pointpicker ) )
		return;

	// Pick the offset point.

	ui.beginUIUpdate();
	ui.hideUI( 'BasePtPrompt' );
	ui.showUI( 'OffsetPtPrompt' );
	ui.endUIUpdate();
		
	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(3) );

	if ( !GetArrayDirPoint( pointpicker ) )
		return;
		

	// If we're in offset, extent mode then pick the second reference point.
		
	if ( ui.commandUI.Mode.value == 'Offset, Extent' )
	{
		ui.beginUIUpdate();
		ui.hideUI( 'OffsetPtPrompt' );
		ui.hideUI( 'ModeTable' );
		ui.hideUI( 'NumItemsTable' );
		ui.showUI( 'ExtentOrOffsetPtPrompt' );
		ui.showUI( 'DisplayNumItemsTable' );
		ui.endUIUpdate();

		pointpicker.clearBindings();
		pointpicker.bindResultPt( factory.getInput(4) );
		ui.commandUI.g_Factory = factory;
		pointpicker.bindFuncPostUpdate( ui.commandUI.OnOffsetExtent );
	
		pointpicker.restrictToLinePtPt( factory.getInput(2).getValue(), factory.getInput(3).getValue(), true );
		pointpicker.disableBasePt = true;

		if ( !GetPoint( pointpicker ) )
			return;
	}
	
	factory.commit();
}

DoArrayDir();
